
#define MAX_NUM_PRIO_BITS	16			// message priority is a 16 bit unsigned
#define INVALID_PRIO 		0xFFFF		// message priority is a 16 bit unsigned

//
// This collection of macros is used as an "adaptation layer" between tinyos code
// and simulation code.
//

// macro to get current time
#define _currentTime call LogicalTime.get()

// macro to reset time
#define _resetTime() call LogicalTime.reset()

// macro to turn carrier sense on 
// try to detect a carrier for the given time interval; 
// signal channel idle at the end of this time interval, if no activity was
// detected in the mean time.
// if the given time interval is 0, it will not stop doing carrier 
// sensing until we say so
#define _radioSetCarrierSenseOn( ) {											\
		call WiDOMCarrierSense.start();											\
}

// macro to turn carrier sense off 
#define _radioSetCarrierSenseOff() {											\
	call WiDOMCarrierSense.stop();												\
}

// macro to set radio to carrier tx mode
#define _setRadioTestMode()														\
{																				\
	call WiDOMCarrierPulse.carrierTXModeStart();								\
}

// macro to set radio to data mode (goes back to "normal" mode)
#define _radioSetNormalMode() {													\
	call WiDOMCarrierPulse.carrierTXModeEnd();									\
}
/*
// macro to set radio to receive data mode (goes back to "normal" mode)
#define _radioSetRx() {															\
	call WiDOMCarrierPulse.carrierTXModeEnd();									\
}

#define _radioSetRx() 
*/
// macro to turn carrier pulse on 
#define _radioSetCarrierOn()													\
{																				\
	call WiDOMCarrierPulse.on();												\
}

// macro to turn carrier pulse off 
#define _radioSetCarrierOff() call WiDOMCarrierPulse.off()

// macro to send a data message to the radio
#define _radioSendDataMsg( _msg ) post SendDataMsg( )

// macro to set an alarm
// macro to give an event when  _currentTime = _when_clkTks 
// time given by '_when_clkTks', in clock ticks, since clock "base time" (x, to match protocol details picture)
// _msgType is only used has a tag to the type to deliver when the alarm fires
#define _setAlarm( _when_clkTks, _msgType ) (call LogicalTime.setAlarm( _when_clkTks, MSG_TYPE_MAC_##_msgType ))		

// cancel alarm
#define _cancelAlarm() call LogicalTime.cancelAlarm();

#define _isAlarmSet() (call LogicalTime.isAlarmSet())

/*
	call UARTDebugger.sendString("NS:CS="); \					
	call UARTDebugger.sendInt(state); \
	call UARTDebugger.sendString(" NS="); \					
	call UARTDebugger.sendInt(_next_state); \
	call UARTDebugger.sendString(" NSV="); \					
	call UARTDebugger.sendInt(MAC_STATE_##_next_state); \
	call UARTDebugger.sendNL(); \
*/	

// macro to call nextState	
#define _nextState( _next_state ) 												\
{																				\
	atomic {																	\
		prevState = state;														\
		state = MAC_STATE_##_next_state;										\
	}																			\
}		

// macro to transition imediatelly to a state
#define _toState( _next_state ) 												\
{																				\
	atomic {																	\
		prevState = state;														\
		state = MAC_STATE_##_next_state;										\
		doWiDOMProtocol(MSG_TYPE_MAC_STATE_ENTER);								\
	}																			\
}		

// this can not be called outsite doWiDOMProtocol() 
#define _queueEmpty() (sendQueue == NULL)

// this can not be called outsite doWiDOMProtocol()
#define _dequeueMsg()															\
{																				\
	sendMsg = sendQueue;														\
	sendQueue = NULL;															\
	prio = sendQueuePrio;														\
}																	

// this can not be called outsite doWiDOMProtocol()
// before putting message back in the queue, check if queue is empty
// though, this can only happen if an acknowlege was put in the queue 
// while in a tournament
#define _enqueueMsg()															\
{																				\
	sendQueue = sendMsg;														\
	sendMsg = NULL;																\
	prio = INVALID_PRIO;														\
}																		

#define _prio( _index ) (!(!(prio & (1 << ((NPRIOBITS - 1) - _index)))))			
								 
#define _winnerPrio( _index, _val ) (winner_prio |= (_val << ((NPRIOBITS - 1) - _index)))
