/*								
 * Copyright (c) 2002 the University of Southern California.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE UNIVERSITY OF SOUTHERN CALIFORNIA BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE
 * UNIVERSITY OF SOUTHERN CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * THE UNIVERSITY OF SOUTHERN CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF SOUTHERN CALIFORNIA HAS NO
 * OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
 * MODIFICATIONS.
 *
 */
 
 /**
 * @author Nuno Pereira
 * Polytechnic Institute of Porto 
 * IPP-HURRAY! 2006
 * 
 * Carrier sense interface  
 *  
 * Heavily based on S-MAC CarrierSense interface, by Wei Ye 
 *  
 */

interface WiDOMCarrierSense {

   // start carrier sense
   // listen duration is specified in WiDOMClockTicks units 
//   async command result_t start(uint16_t clkTks);
   async command result_t start();

   // stop any carrier sense going on
   async command result_t stop();

   // signal events when channel busy or idle is detected
   // carrier sense automatically stops when detection is done
   async event result_t channelIdle();
   async event result_t channelBusy();
   
   /* IMPORTANT NOTES:
    *    1) If CarrierSense.start returns SUCCESS, either channelIdle or
    *       channelBusy must be signalled.

    *	 2)	It is possible that channelBusy is signalled right after 
    *       CarrierSense.start returns SUCCESS. 
    *     	Therefore, anything similar to 
    *        
    *    	if (CarrierSense.start() == SUCCESS) state = CARR_SENSE;
    *       
    *       must be atomic.
    *    
    */
}
