
#define DEFINE_WiDOMTEST_HEADER_SIZE 9
#define	DEFINE_WiDOMTEST_DATA_LENGHT 12

enum {
	WiDOMTEST_HEADER_SIZE = DEFINE_WiDOMTEST_HEADER_SIZE,
	WiDOMTEST_DATA_LENGHT = DEFINE_WiDOMTEST_HEADER_SIZE,
	WiDOMTEST_MSG_LENGHT = DEFINE_WiDOMTEST_HEADER_SIZE + DEFINE_WiDOMTEST_DATA_LENGHT,
	WiDOMTEST_PKT_TYPE_DATA = 0xAA,
	WiDOMTEST_PKT_TYPE_FINISH=0xFF  
};

typedef struct WiDOMTestMsgHeader
{
	uint16_t srcAddr;
	uint16_t prio;
  	uint32_t seqCounter;
  	uint8_t won_tournament; // this is set locally by the MAC protocol to indicate that the message received won a tournament against us  	
} *WiDOMTestMsgHeaderPtr;

typedef struct WiDOMTestMsg
{
	uint16_t srcAddr;
	uint16_t prio;
  	uint32_t seqCounter;
  	uint8_t won_tournament; // this is set locally by the MAC protocol to indicate that the message received won a tournament against us
  	  	
	int8_t data[WiDOMTEST_DATA_LENGHT];  	
} *WiDOMTestMsgPtr; 


typedef struct WiDOMTestMsgRcv // TEMP: used to carry counters from MAC to app when a stats message is received
{
	uint16_t srcAddr;
	uint16_t prio;
  	uint32_t seqCounter;
  	uint8_t won_tournament; 
  	
  	uint32_t numTournaments;
  	uint32_t numRxTimeouts;
  	uint32_t numTxTimeouts;
  	
} *WiDOMTestMsgRcvPtr; 

/*
typedef WiDOMTestMsg *WiDOMTestMsgPtr;

typedef WiDOMTestMsgHeader *WiDOMTestMsgHeaderPtr;
*/
