
/*
 *
 * @author Nuno Pereira
 * @date 02/2006 
 * 
 */


//
// Available ATMega128 prescalers 
//
//CPUCLK = 7.3728MHz
#define TCLK_CPU_DIV1 1	 	
//CPUCLK/8 = 921,6 KHz (~1,085 us intervals)
#define TCLK_CPU_DIV8 2	
//CPUCLK/64 = 115,2 KHz (~8,681 us intervals)
#define TCLK_CPU_DIV64 3	
//CPUCLK/256 = 28,8 KHz (~34,722 us intervals)
#define TCLK_CPU_DIV256 4
//CPUCLK/1024 = 7,2 KHz (~138,889 us intervals)
#define TCLK_CPU_DIV1024 5	
/*
enum {
  TCLK_CPU_OFF = 0,
  TCLK_CPU_DIV1 =1,	 	//CPUCLK 		= 7.3728MHz
  TCLK_CPU_DIV8 = 2,	//CPUCLK/8 		= 921,6 KHz	(~1,085 us intervals)
  TCLK_CPU_DIV64 = 3,	//CPUCLK/64 	= 115,2 KHz	(~8,681 us intervals)
  TCLK_CPU_DIV256 = 4,	//CPUCLK/256 	= 28,8 KHz 	(~34,722 us intervals)
  TCLK_CPU_DIV1024 = 5	//CPUCLK/1024 	= 7,2 KHz 	(~138,889 us intervals)
};
*/
#define  WiDOMT_SCALE TCLK_CPU_DIV256
#define  WiDOMT_INTERVAL 0

/*****************************************************************************
Provides a highresolution timer for WiDOM 
Uses ATMega128 Timer2 via HPLTimer2
*****************************************************************************/
module WiDOMClockM
{
	provides 
	{
		interface SplitControl;
		interface WiDOMLogicalTime;
		interface WiDOMClockTicks;
	}
  	
	uses interface Clock as Timer;
}

implementation
{
	uint32_t alarmTime;
	uint8_t alarmType;
	bool doPost;
	uint32_t timerCounter;
	
	command result_t SplitControl.init()
	{
		signal SplitControl.initDone();
		return SUCCESS;
	}
	
	command result_t SplitControl.start()
	{
		atomic {
			timerCounter = 0;
			alarmTime = 0;
			alarmType = 0;
			doPost = FALSE;
						
		}
	  	call Timer.setIntervalAndScale(WiDOMT_INTERVAL, WiDOMT_SCALE);  //sets timer, starts and enables interrupt
	  	signal SplitControl.startDone();
		return SUCCESS;
	}
	
	command result_t SplitControl.stop()
	{
		atomic {
			alarmTime = 0;
			doPost = FALSE;
			call Timer.intDisable();
		}
		signal SplitControl.stopDone();
		return SUCCESS;
	}
	
	async event result_t Timer.fire() {
		bool _doPost;
		uint8_t _alarmType=0;
		
		atomic {
			timerCounter++;
			_doPost = doPost;
			if (alarmTime != 0) {
				if (timerCounter >= alarmTime) {
					alarmTime = 0;
					_alarmType = alarmType;
					signal WiDOMLogicalTime.alarm(_alarmType);				
				}
			}
		}

		if (_doPost) signal WiDOMClockTicks.tick();		

		return SUCCESS;
	}

	async command result_t WiDOMClockTicks.postTicks(bool posting) {
		atomic doPost = posting;
		return SUCCESS;
	}

	async command uint32_t WiDOMLogicalTime.get() {
		uint32_t _timerCounter;
		atomic _timerCounter = timerCounter;
		return _timerCounter;
	}	

	async command result_t WiDOMLogicalTime.reset() {
		atomic {
			timerCounter = 0;
		}
		return SUCCESS;		
	}

	async command result_t WiDOMLogicalTime.setAlarm(uint32_t when, uint8_t type) 
	{
		result_t res = FAIL;
		
		atomic {
			alarmTime = when;
			alarmType = type;
			res = SUCCESS;
		}
		return res;
	}

	async command result_t WiDOMLogicalTime.cancelAlarm() {
		result_t ret=FAIL;
		atomic {		
			if (alarmTime != 0)	{
				atomic alarmTime = 0;
				ret = SUCCESS; 
			}
		}
		return ret;
	} 
	
	async command bool WiDOMLogicalTime.isAlarmSet()
	{
		bool alarm;
		atomic alarm = (bool)alarmTime;
		return alarm;
	}
}
