/*
 *
 * @author Nuno Pereira
 * @date 02/2006 
 *
 *
 */

#define QUEUE_SIZE 2000             
 
module UARTDebuggerM {
	provides interface UARTDebugger;
  	uses interface HPLUART;
  	uses interface Leds;
}

implementation {
		
	bool sending;

	char queue[QUEUE_SIZE];
	int start, end;
	
	async command result_t UARTDebugger.init() {			
		call HPLUART.init();
		call Leds.init();
		atomic {
			sending = FALSE;
			start = end = -1;
		}
		return SUCCESS;
	}

	async command result_t UARTDebugger.stop() {
		call HPLUART.stop();
		return SUCCESS;
	}	

	result_t insert(char val) {
		bool res = FAIL;
		atomic {
		    if(end<QUEUE_SIZE-1) { 
		        end++;
		        queue[end]=val;
		        if (start==-1) start=0;
				res = SUCCESS;
			}
		}	
		return res;
	}
	
	char remove(result_t *result) { 
	    char val=0;					
	    atomic {
			if(start>=0) {
		        val=queue[start];
		        if(start==end) start=end=-1;
		        else start++;
				*result = SUCCESS;					
		    } else *result = FAIL;
		}
		return val;		
	}

	bool queueFull() {
		bool qf;
		atomic qf = (end>=QUEUE_SIZE-1);
		return qf;
	}
	
	int writeUnsignedInt(uint16_t number, char* out, uint8_t digits) {
		const uint8_t pots = 5;
		const uint16_t pot[] = { 1, 10, 100, 1000, 10000 };
		uint8_t pos = 0;
		uint8_t t;
		uint8_t j;
		for (j=pots; j>0; j--) {
			t = 0x30;
			while(number >= pot[j-1]){ number -= pot[j-1]; t++; }
			if( (t>0x30) || (pos>0) || (j<=digits) ) out[pos++] = t;
		}
		out[pos++] = '\0';
		return pos;
	}
	
	async command result_t UARTDebugger.sendChar(uint8_t data) {
		bool _sending;
		if (queueFull() == TRUE) return FAIL; 
		atomic _sending = sending;
		if (_sending == FALSE) call HPLUART.put(data);
		else insert(data);
		return SUCCESS;
	}

	async command result_t UARTDebugger.sendChars(char* data, int n) {
		int i;
		result_t res=SUCCESS;
		if (queueFull() == TRUE || n == 0) return FAIL;
		atomic {
			i=0;
			while (i < n && res == SUCCESS) res &= insert(data[i++]);
			if (res == SUCCESS) {
				if (sending == FALSE) {
					sending = TRUE;
					call HPLUART.put(remove(&res));
				}
			}
		}		
		return res;	
	}

	async command result_t UARTDebugger.sendString(const char* string) {
		int i=0;
		result_t res=SUCCESS;
		if (queueFull() == TRUE || string[0] == 0) return FAIL;
		atomic {
			while (string[i] && res == SUCCESS) res &= insert(string[i++]);
			if (res == SUCCESS) {
				if (sending == FALSE) {
					sending = TRUE;
					call HPLUART.put(remove(&res));
				}
			}
		}		
		return res;		
	}

	async command result_t UARTDebugger.sendStringNL(const char* string) {
		int i=0;
		result_t res=SUCCESS;
		if (queueFull() == TRUE || string[0] == 0) return FAIL;
		atomic {
			while (string[i] && res == SUCCESS) res &= insert(string[i++]);
			res &= insert('\n');
			res &= insert('\r');
			if (res == SUCCESS) {
				if (sending == FALSE) {
					sending = TRUE;
					call HPLUART.put(remove(&res));
				}
			}
		}		
		return res;		
	}

	async command result_t UARTDebugger.sendInt(int data) {
		char tmp[10];
		if (queueFull() == TRUE) return FAIL;
		if (data==0) call UARTDebugger.sendChar('0');
		return call UARTDebugger.sendChars(&tmp[0], writeUnsignedInt(data, &tmp[0], 0)-1);
	}

	async command result_t UARTDebugger.sendTaggedInt(const char* string, int data) {
		result_t res=SUCCESS;
		atomic {
			res &= call UARTDebugger.sendString(string);
			res &= call UARTDebugger.sendInt(data);
		}	
		return res;
	}

	async command result_t UARTDebugger.sendTaggedIntNL(const char* string, int data) {
		result_t res=SUCCESS;
		atomic {
			res &= call UARTDebugger.sendString(string);
			res &= call UARTDebugger.sendInt(data);		
			res &= call UARTDebugger.sendChars("\n\r", 2);
		}
		return res;
	}

	async command result_t UARTDebugger.sendNL() {
		return call UARTDebugger.sendChars("\n\r", 2);
	}

 	event async result_t HPLUART.putDone() {
		bool _sending; 		
		char data;
		atomic _sending = sending;
		if (_sending == TRUE) {	
			data = remove(&_sending);
			atomic sending = _sending;
			if (_sending) call HPLUART.put(data); 		
		}
		return SUCCESS;
	}

	event async result_t HPLUART.get(uint8_t data) {
		return SUCCESS;
	}
}
