
// MAC protocol states, according to Fig. 1 from: 
// N. Pereira, B. Andersson and E. Tovar, "Implementation of a Dominance Protocol for Wireless Medium Access". 
enum MAC_STATES {
	MAC_STATE_0,			
	MAC_STATE_1,		
	MAC_STATE_2,
	MAC_STATE_3,
	MAC_STATE_4,
	MAC_STATE_5,
	MAC_STATE_6,
	MAC_STATE_7,
	MAC_STATE_8,
	MAC_STATE_9,
	MAC_STATE_10,
	MAC_STATE_11
};

//
//
// Message Types
enum MSG_TYPES {
	MSG_TYPE_DATA_MSG,						// (0)
	
// MAC messages
	MSG_TYPE_MAC_QUEUE,						// (1) A new message was queued
	MSG_TYPE_MAC_WAIT_TIME_E,				// (2) MAC ended waiting for E
	MSG_TYPE_MAC_WAIT_TIME_F,				// (3) MAC ended waiting initial idle period (F)
	MSG_TYPE_MAC_WAIT_TIME_G,				// (4) MAC ended waiting for guard time (G)
	MSG_TYPE_MAC_WAIT_TIME_H,				// (5) MAC ended waiting carrier sense (H)
	MSG_TYPE_MAC_WAIT_TIME_R,				// (6) MAC ended waiting period for increase of synchronization reliability (R)
	MSG_TYPE_MAC_WAIT_TIME_SWX,				// (7) MAC ended waiting for SWX
	MSG_TYPE_MAC_WAIT_TIME_TFCS,			// (8) MAC ended waiting for initial carrier sensing time
	MSG_TYPE_MAC_WAIT_TIME_ETG,				// (9) End of tournament gap
	MSG_TYPE_MAC_WAIT_TIME_RXTIMEOUT,		// (10) Timeout for receiving a message
	MSG_TYPE_MAC_STATE_ENTER,				// (11) used when the MAC protocol enters a state, after a state transition with _toState()
	
// Radio messages
	MSG_TYPE_RADIO_CHANNEL_IDLE,			// (12) Channel is idle 
	MSG_TYPE_RADIO_CHANNEL_BUSY,			// (13) Channel is busy (a carrier or a transmission detected)
	MSG_TYPE_RADIO_END_RX,					// (14) end receiving a * data message * 
	MSG_TYPE_RADIO_END_TX					// (15) end sending a * data message *
};

//
//
// Debug Level and Mask definitions.
enum DBG_LEVEL {
	dbgLevelDeath=1,
	dbgLevelCriticalError,
	dbgLevelFailure,
	dbgLevelInfo,
	dbgLevelTrace,
	dbgLevelVerbose
};

enum DBG_MASK {
	dbgMaskInit=1,
	dbgMaskMACMsgs,
	dbgMaskMACClock,
	dbgMaskMACProtocol, 
	dbgMaskMAC=dbgMaskMACMsgs+dbgMaskMACClock+dbgMaskMACProtocol,
	dbgMaskRadio,
	dbgMaskStream,
	dbgMaskStat,
	dbgMaskAll=0XFFFFFFFF
};

// Clock resolution (us)
#define CLOCK_TICK_TIME	34.72222 	

const int NPRIOBITS	= 10;

// timeouts constants (in us)
#define E_us 		312 	// timeout to improve reliability 
#define F_us 		21770	// initial idle period
#define H_us 		1145 	// duration of a pulse of a carrier
#define G_us 		555 	// "guarding" time interval 
#define ETG_us 		520		// end Tournament GAP
#define TFCSBG_us 	256		// time to detect a carrier at the beggining of the tournament
#define TFCS_us 	486		// time to detect a carrier (value from experiments)
#define SWX_us 		192		// RX/TX switch time (CC2420 datasheet)
#define CMAX_us 	768		// max time to tx our messages (30 bytes+preamble and sfd)


// timeouts constants (rounded up to clock ticks)
const int E 		= ( E_us ) / CLOCK_TICK_TIME + 1; 			// 
const int F 		= ( F_us ) / CLOCK_TICK_TIME + 1 ; 			//  	 
const int H 		= ( H_us ) / CLOCK_TICK_TIME + 1; 			// 
const int G 		= ( G_us ) / CLOCK_TICK_TIME + 1; 			//  
const int TFCSBG	= ( TFCSBG_us ) / CLOCK_TICK_TIME + 1;		//
const int TFCS 		= ( TFCS_us ) / CLOCK_TICK_TIME + 1;		// 
const int SWX 		= ( SWX_us ) / CLOCK_TICK_TIME + 1;			// 
const int CMAX 		= ( CMAX_us * 1.5 ) / CLOCK_TICK_TIME + 1;	//
const int ETG 		= ( ETG_us ) / CLOCK_TICK_TIME + 1;			//
