/*
 *
 * @author Nuno Pereira
 * @date 02/2006 
 *
 *
 * Logical time used by WiDOM state machine
 * Time units are WiDOMT_SCALE, defined in WiDOMClockM  
 */

interface WiDOMLogicalTime
{
   // get current logical time
   async command uint32_t get();

   // reset logical time
   async command result_t reset();

   // set alarm to be fired at when; the corresponding event will return the type given 
   // IMPORTANT: only supports one alarm pending at a time!
   async command result_t setAlarm(uint32_t when, uint8_t type);
   
   // cancel alarm previously set
   async command result_t cancelAlarm();
   
   // check if an alarm is set
   async command bool isAlarmSet();
	   
   // signal alarms
   async event void alarm(uint8_t type);
}
