/*
 * Wrapper for linear feedback shift register used in TinyOs
 * to generate random numbers
 *
 */
#pragma once

class cRandomLFSR
{
 protected:
	bool				init;
	unsigned __int16	shiftReg;
	unsigned __int16	initSeed;
	unsigned __int16	mask;

public:
	cRandomLFSR(void) { init = false; }
	/* Initialize the seed from the ID of the node */
    cRandomLFSR(int id);
	~cRandomLFSR(void);

	/* Initialize the seed from the ID of the node */
    void initialize(int id);
	/* Return the next 16 bit random number */
	unsigned __int16 rand();
};
