/*
 * Wrapper for linear feedback shift register used in TinyOs
 * to generate random numbers
 *
 */

/*
Notes on the implementation of a larger PRNG in TinyOS. 

A very simple algorithm to generate large random numbers
-----------------------------------------------------------
Assumptiom: + The function random generates a uniformly distributed random 
              number in the range [0..32767].
            + r is a 32-bit random number.

Return:		r, the random number generated.

r1 := random mod 32768
r2 := random mod 32768
r  := r1*32768+r2;

Note: It uses only 30 bits.

This technique (or something similar) would enable using a really large MAXV.
*/

#include "crandomlfsr.h"

cRandomLFSR::cRandomLFSR(int id) {
	initialize(id);
}

cRandomLFSR::~cRandomLFSR(void)
{
}

/* Initialize the seed from the ID of the node */
void cRandomLFSR::initialize(int id) {
	shiftReg = 119 * 119 * (id + 1);
	initSeed = shiftReg;
	mask = 137 * 29 * (id + 1);
	init = true;
}

/* Return the next 16 bit random number; interval: [0, 0xFFFF] */
unsigned __int16 cRandomLFSR::rand() {

	if (init==false) throw "Linear feedback shift register pseudorandom number generator not initialized!";

	bool endbit;
	unsigned __int16 tmpShiftReg;

	tmpShiftReg = shiftReg;
	endbit = ((tmpShiftReg & 0x8000) != 0);
	tmpShiftReg <<= 1;
	if (endbit) 
		tmpShiftReg ^= 0x100b;
	tmpShiftReg++;
	shiftReg = tmpShiftReg;
	tmpShiftReg = tmpShiftReg ^ mask;

	return tmpShiftReg;
}