// interpolation.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAXNNODES 6000
#define NNODES 6000
#define NCONTROLPOINTS 6

#define MAXV 2
#define MINV -1

struct control_point {
  double value;
  int x;
  int y;
  // double invdistance2;
};

struct node {
  int myid;
  int x; // from 1..1000, this is millimeter
  int y; // from 1..1000, this is millimeter
  double value;
  int ncontrol_points;
  struct control_point control_points[NCONTROLPOINTS+1];
  double numerator;
  double denominator;
};

double datagrid[1001][1001];
double noisedatagrid[1000+1][1000+1];
double ourinterpolationdatagrid[1000+1][1000+1];
double randominterpolationdatagrid[1000+1][1000+1];

struct node nodes[NNODES+1];

struct node randomnode;

void initialize_datagrid()
{
  int x; int y;
  double xm; double ym;
  double sumsqr;
  // double sumsqr1;
  // double sumsqr2;
  for (x=1;x<=1000;x++) {
    for (y=1;y<=1000;y++) {
	  xm = x/1000.0;
	  ym = y/1000.0;
	  sumsqr = ( (xm-0.5)*(xm-0.5)+
	             (ym-0.5)*(ym-0.5) );
	  datagrid[x][y] = exp(-7.0*sumsqr)+0.1;
	  /*
	  sumsqr1 = ( (xm-0.2)*(xm-0.2)+
		         (ym-0.2)*(ym-0.2) );
	  sumsqr2 = ( (xm-0.8)*(xm-0.8)+
		         (ym-0.8)*(ym-0.8) );
	  datagrid[x][y] = exp(-7.0*sumsqr1)*0.9+exp(-7.0*sumsqr2)*0.9+0.1;
	  datagrid[x][y] = exp(-7.0*sumsqr1)*0.9+exp(-7.0*sumsqr2)*0.9+0.1;

      if ((200<=x) && (x<=800) && (200<=y) && (y<=800))
	    datagrid[x][y] = 0.1;
	  else {
        if ((100<=x) && (x<=900) && (100<=y) && (y<=900))
	      datagrid[x][y] = 0.3;
		else
          datagrid[x][y] = 0.9;
	  }
	  */
	}
  }
}

double drand48()
{
  int r;
  double r2;
  r = rand()%1000;
  r2 = r;
  return r2/1000;
}

void initialize_noisedatagrid()
{
  int x; int y;
  double noise;
  for (x=1;x<=1000;x++) {
    for (y=1;y<=1000;y++) {
      noise = drand48()*0.20;
      // printf("noise = %lf\n", noise);
      noisedatagrid[x][y] = datagrid[x][y] + noise;
    }
  }
}

int random()
{
  return rand();
}

void initialize_nodes()
{
  struct node anode;
  int i; int j;
  for (i=1;i<=NNODES;i++) {
	do {
      anode.myid = 1;
      anode.x   = 1+random()%1000;
      anode.y   = 1+random()%1000;
      anode.value = noisedatagrid[anode.x][anode.y];
      anode.ncontrol_points = 0;
      for (j=1;j<i;j++) {
        if ( (nodes[j].x==anode.x) &&
             (nodes[j].y==anode.y) )
          j = i+2;
      }
    } while (j==i+2);
    nodes[i] = anode;
  }
}

double calculate( int i, int x, int y)
{
  double numerator; double denominator;
  struct node anode;
  int j;
  struct control_point acontrol_point;
  int diffx; int diffy;
  double diffxm; double diffym;
  double invdist2;
  anode = nodes[i];
  numerator = 0;
  denominator = 0;
  if (anode.ncontrol_points==0)
    return 0.0;
  else {
    for (j=1;j<=anode.ncontrol_points;j++) {
      acontrol_point = anode.control_points[j];
      diffx = (acontrol_point.x-x);
      diffy = (acontrol_point.y-y);
      diffxm = diffx/1000.0;
      diffym = diffy/1000.0;
	  if ((diffx==0) && (diffy==0)) {
        invdist2 = 1.0/( 0.0001*0.0001);
      } else {
        invdist2 = 1.0/( diffxm*diffxm+diffym*diffym );
      }
      numerator   = numerator   + acontrol_point.value*invdist2;
      denominator = denominator + invdist2;  
    }
    return numerator/denominator;
  }
}

double calculate_based_on_random_points( int x, int y)
{
  double numerator; double denominator;
  struct node anode;
  int j;
  struct control_point acontrol_point;
  int diffx; int diffy;
  double diffxm; double diffym;
  double invdist2;
  anode = randomnode;
  numerator = 0;
  denominator = 0;
  if (anode.ncontrol_points==0)
    return 0.0;
  else {
    for (j=1;j<=anode.ncontrol_points;j++) {
      acontrol_point = anode.control_points[j];
      diffx = (acontrol_point.x-x);
      diffy = (acontrol_point.y-y);
      diffxm = diffx/1000.0;
      diffym = diffy/1000.0;
	  if ((diffx==0) && (diffy==0)) {
        invdist2 = 1.0/( 0.0001*0.0001);
      } else {
        invdist2 = 1.0/( diffxm*diffxm+diffym*diffym );
      }
      numerator   = numerator   + acontrol_point.value*invdist2;
      denominator = denominator + invdist2;  
    }
    return numerator/denominator;
  }
}

void print_datagrid()
{
  int xindex; int yindex; int x; int y;
  printf("[X,Y] = meshgrid(0.001:0.005:1, 0.001:0.005:1);\n"); 
  for (xindex=1;xindex<=200;xindex++) {
    for (yindex=1;yindex<=200;yindex++) {
	  x = xindex*5; y = yindex*5;
	  printf("datagrid(%d,%d)=%lf;\n", xindex, yindex, datagrid[x][y] );
    }
  }
  printf("AXIS([0 1 0 1 -0.4 1.4])\n");
  printf("mesh(Y,X,datagrid);\n");
  // printf("title(['The signal without noise',''])\n");
  printf("AXIS([0 1 0 1 -0.4 1.4])\n");
  printf("XLABEL(['x',''])\n");
  printf("YLABEL(['y',''])\n");
  printf("ZLABEL(['signal',''])\n");
  printf("print -dps datagrid.eps\n");
}

void print_noisedatagrid()
{
  int xindex; int yindex; int x; int y;
  printf("[X,Y] = meshgrid(0.001:0.005:1, 0.001:0.005:1);\n"); 
  for (xindex=1;xindex<=200;xindex++) {
    for (yindex=1;yindex<=200;yindex++) {
	  x = xindex*5; y = yindex*5;
	  printf("noisedatagrid(%d,%d)=%lf;\n", xindex, yindex, noisedatagrid[x][y] );
    }
  }
  printf("AXIS([0 1 0 1 -0.4 1.4])\n");
  printf("mesh(Y,X,noisedatagrid);\n");
  // printf("title(['The signal with noise',''])\n");
  printf("AXIS([0 1 0 1 -0.4 1.4])\n");
  printf("XLABEL(['x',''])\n");
  printf("YLABEL(['y',''])\n");
  printf("ZLABEL(['signal',''])\n");
  printf("print -dps noisedatagrid.eps\n");
}

void print_ourinterpolationdatagrid()
{
  int j; struct node anode;
  struct control_point acontrol_point;
  double xfloat; double yfloat; double zfloat;
  int xindex; int yindex; int x; int y;
  printf("[X,Y] = meshgrid(0.001:0.005:1, 0.001:0.005:1);\n"); 
  for (xindex=1;xindex<=200;xindex++) {
    for (yindex=1;yindex<=200;yindex++) {
	  x = xindex*5; y = yindex*5;
      ourinterpolationdatagrid[x][y] = calculate( 1, x, y);
	  printf("ourinterpolationdatagrid(%d,%d)=%lf;\n", xindex, yindex, ourinterpolationdatagrid[x][y] );
    }
  }

  printf("AXIS([0 1 0 1 -0.4 1.4])\n");
  printf("mesh(Y,X,ourinterpolationdatagrid);\n");
  anode = nodes[1];
  for (j=1;j<=anode.ncontrol_points;j++) {
    acontrol_point = anode.control_points[j];
    xfloat = acontrol_point.x/1000.0;
    yfloat = acontrol_point.y/1000.0;
	zfloat = acontrol_point.value;
    printf("line([%lf %lf], [%lf %lf], [%lf %lf], 'LineWidth', 4);\n", xfloat, xfloat, yfloat, yfloat, -0.4, 1.4);
  }
  // printf("title(['Our interpolation scheme',''])\n");
  printf("AXIS([0 1 0 1 -0.4 1.4])\n");
  printf("XLABEL(['x',''])\n");
  printf("YLABEL(['y',''])\n");
  printf("ZLABEL(['signal',''])\n");
  printf("print -dps ourinterpolationdatagrid.eps\n");
}

void print_randompointinterpolationdatagrid()
{
  int j; struct node anode;
  struct control_point acontrol_point;
  double xfloat; double yfloat; double zfloat;
  int xindex; int yindex; int x; int y;
  printf("[X,Y] = meshgrid(0.001:0.005:1, 0.001:0.005:1);\n"); 
  for (xindex=1;xindex<=200;xindex++) {
    for (yindex=1;yindex<=200;yindex++) {
	  x = xindex*5; y = yindex*5;
	  randominterpolationdatagrid[x][y] = calculate_based_on_random_points( x, y);
      //if ((85<=x) && (x<=85) && (750<=y) && (y<=750))
	  printf("randominterpolationdatagrid(%d,%d)=%lf;\n", xindex, yindex, randominterpolationdatagrid[x][y] );
    }
  }
  printf("AXIS([0 1 0 1 -0.4 1.4])\n");
  printf("mesh(Y,X,randominterpolationdatagrid);\n");
  anode = randomnode;
  for (j=1;j<=anode.ncontrol_points;j++) {
    acontrol_point = anode.control_points[j];
    xfloat = acontrol_point.x/1000.0;
    yfloat = acontrol_point.y/1000.0;
	zfloat = acontrol_point.value;
    printf("line([%lf %lf], [%lf %lf], [%lf %lf], 'LineWidth', 4);\n", xfloat, xfloat, yfloat, yfloat, -0.4, 1.4);
  }
  // printf("title(['Interpolation scheme with random points',''])\n");
  printf("AXIS([0 1 0 1 -0.4 1.4])\n");
  printf("XLABEL(['x',''])\n");
  printf("YLABEL(['y',''])\n");
  printf("ZLABEL(['signal',''])\n");
  printf("print -dps randominterpolationdatagrid.eps\n");
}

#define MAXPRIO 500000000
// it is assumed that the MINPRIO = 0.

struct packet {
  int priority;
  double value;
  int x;
  int y;
};

// int go_on[NNODES+1];
int updatemyinterpolation[NNODES+1];
double myinterpolated_value[NNODES+1];
struct packet packets[NNODES+1];

void run_our_algorithm()
{
  int i;
  int round;
  double error;
  int MAXVFORerror;
  double f;
  int prio;
  int found;
  int leastprio;
  int nodewithleastprio;
  int diffx; int diffy;
  double diffxm; double diffym;
  double invdist2;
  int j;
  for (i=1;i<=NNODES;i++) {
    updatemyinterpolation[i] = 1;
    myinterpolated_value[i] = 0.0;
	nodes[i].numerator = 0.0;
	nodes[i].denominator = 0.0;
  }
  for (round=1;round<=NCONTROLPOINTS;round++) {
    for (i=1;i<=NNODES;i++) {
      error = fabs( myinterpolated_value[i]-nodes[i].value);
      MAXVFORerror = MAXPRIO/(MAXNNODES+1);
      f = (MAXV-error)/(MAXV-MINV);
      prio = MAXVFORerror*f;
      packets[i].priority = prio*(MAXNNODES+1) + i;
      packets[i].value = nodes[i].value;
      packets[i].x     = nodes[i].x;
      packets[i].y     = nodes[i].y;
    }
    leastprio = packets[1].priority;
    nodewithleastprio = 1;
    for (i=1;i<=NNODES;i++) {
      // if ( (go_on[i]==1) && ((packets[i].priority<leastprio) || (found==0)) ) {
      if (packets[i].priority<leastprio) {
		leastprio = packets[i].priority;
	    nodewithleastprio = i;
      }
    }
	for (i=1;i<=NNODES;i++) {
	  if (packets[nodewithleastprio].priority == packets[i].priority) {
        updatemyinterpolation[i] = 0;
        myinterpolated_value[i] = packets[nodewithleastprio].value;
	  }
	  if (updatemyinterpolation[i]==1) {
	    diffx = (nodes[i].x-packets[nodewithleastprio].x);
        diffy = (nodes[i].y-packets[nodewithleastprio].y);
        diffxm = diffx/1000.0;
        diffym = diffy/1000.0;
        invdist2 = 1.0/( diffxm*diffxm+diffym*diffym );
		nodes[i].numerator   = nodes[i].numerator + packets[nodewithleastprio].value*invdist2;
        nodes[i].denominator = nodes[i].denominator + invdist2;
	    myinterpolated_value[i] = nodes[i].numerator / nodes[i].denominator;
	  }
	  // nodes[i].control_points[j].invdistance2 = invdist2;
	  j = nodes[i].ncontrol_points+1;
      nodes[i].control_points[j].value        = packets[nodewithleastprio].value;
      nodes[i].control_points[j].x            = packets[nodewithleastprio].x;
      nodes[i].control_points[j].y            = packets[nodewithleastprio].y;
 	  nodes[i].ncontrol_points = nodes[i].ncontrol_points + 1;
    }
  }
}

void setuprandomnode()
{
  int round; int nodeindex; int j;
  randomnode.ncontrol_points = 0;
  for (round=1;round<=NCONTROLPOINTS;round++) {
    nodeindex = random()%NNODES+1;
    j = randomnode.ncontrol_points+1;
	randomnode.control_points[j].value        = nodes[nodeindex].value;
	randomnode.control_points[j].x            = nodes[nodeindex].x;
	randomnode.control_points[j].y            = nodes[nodeindex].y;
    // randomnode.control_points[j].invdistance2 = -1;
	randomnode.numerator   = -1;
    randomnode.denominator = -1;
	randomnode.ncontrol_points = randomnode.ncontrol_points + 1;
  }
}


void print_controlpoints()
{
  struct node anode;
  struct control_point acontrol_point;
  int j;
  double xm; double ym;
  anode = nodes[1];
  for (j=1;j<=anode.ncontrol_points;j++) {
    acontrol_point = anode.control_points[j];
    xm = acontrol_point.x/1000.0;
    ym = acontrol_point.y/1000.0;
	printf("%lf %lf %lf\n", xm, ym, acontrol_point.value );
  }
}

void print_randomcontrolpoints()
{
  struct node anode;
  struct control_point acontrol_point;
  int j;
  double xm; double ym;
  anode = randomnode;
  for (j=1;j<=anode.ncontrol_points;j++) {
    acontrol_point = anode.control_points[j];
    xm = acontrol_point.x/1000.0;
    ym = acontrol_point.y/1000.0;
	printf("%lf %lf %lf\n", xm, ym, acontrol_point.value );
  }
}



int main()
{
  initialize_datagrid();
  initialize_noisedatagrid();
  initialize_nodes();
  run_our_algorithm();
  setuprandomnode();
  // print_controlpoints();
  print_datagrid();
  print_noisedatagrid();
  print_ourinterpolationdatagrid();
  // print_randomcontrolpoints();
  // printf("86 751 = %lf\n", calculate_based_on_random_points( 86, 751) );
  print_randompointinterpolationdatagrid();
}


