/* ========================================================================== */
/*                                                                            */
/*   simple_rtc.h                                                             */
/*   (c) 2007 Nuno Pereira                                                    */
/*                                                                            */
/*   Description                                                              */
/*          Simple 32 bit timer for atmega128                                 */
/*          Uses Timer/Counter3                                               */
/* ========================================================================== */
#ifndef _BASIC_RTC_H_
#define _BASIC_RTC_H_

#include "config.h"

/*
#if USE_TIMER16 == TIMER16_3
  #error "Configure USE_TIMER16 to use other timer than TIMER16_3!"
#endif
*/	
#define BM( n ) ((1 << (n)))
#define TCLK_CPU_DIV1 1 //PRESCALER FOR THE MICROCONTROLLER

#if FOSC == 8000
#define CLOCK_TICK_TIME_us		0.125
#elif FOSC == 16000
#define CLOCK_TICK_TIME_us		0.0625
#elif
#error "Unsupported Clock Rate in basic_rtc.h!"
#endif

//-------------------------------------------------------------------------------------------------------
//	void simple_rtc_init()
//
//	DESCRIPTION:
//		Initializes and starts a high speed timer for atmega 128 (Timer/Counter3).
//		Enables overflow interrupt.
//
//-------------------------------------------------------------------------------------------------------
void simple_rtc_init();

//-------------------------------------------------------------------------------------------------------
//	void simple_rtc_reset()
//
//	DESCRIPTION:
//		Resets the already running timer (makes it ZERO).
//		(atmega 128 Timer/Counter3)
//
//-------------------------------------------------------------------------------------------------------
inline void simple_rtc_reset();

//-------------------------------------------------------------------------------------------------------
//	void simple_rtc_stop()
//
//	DESCRIPTION:
//		Stops the already started timer.
//		Usefull for "stop-start" situations along with simple_rtc_start.
//		(atmega 128 Timer/Counter3)
//
//-------------------------------------------------------------------------------------------------------
inline void simple_rtc_stop();

//-------------------------------------------------------------------------------------------------------
//	void simple_rtc_start()
//
//	DESCRIPTION:
//		Starts the already initialized timer (with simple_rtc_init).
//		Usefull to resume counting after a simple_rtc_stop.
//		(atmega 128 Timer/Counter3)
//
//-------------------------------------------------------------------------------------------------------
inline void simple_rtc_start();

//-------------------------------------------------------------------------------------------------------
//	uint32_t simple_rtc_get()
//
//	DESCRIPTION:
//		Returns timer value stored in TCNT1 register.
//		(atmega 128 Timer/Counter3)
//
//-------------------------------------------------------------------------------------------------------
inline uint32_t simple_rtc_get();

inline void simple_rtc_wait_until(uint32_t when_clkTks);

inline void simple_rtc_wait_for(uint32_t time_clkTks);

#endif
