/* ========================================================================== */
/*                                                                            */
/*   my_can.h                               								  */
/*   (c) 2007 Nuno Pereira                                                    */
/*                                                                            */
/*   Description                                                              */
/*          Basic can wrapper functions			                  			  */
/* ========================================================================== */

#ifndef _MY_CAN_H_
#define _MY_CAN_H_

#include "config.h"
#include "can_lib.h"
#include "can_drv.h"
#include "simple_rtc.h"

extern st_cmd_t message_rx;
extern st_cmd_t message_tx;

extern U8 buffer_rx[8];

#define TYPE_START_INTERPOLATION_ITERATION 	0 		// Custom data
#define TYPE_INTERPOLATION_DATA 			1		// types used

#define LEN_MSG_NO_PAYLOAD_BITS 	64
#define LEN_MSG_PAYLOAD_BYTES 		6
#define LEN_START_MSG_PAYLOAD_BYTES	2
#define LEN_MSG_PAYLOAD_BITS		(LEN_MSG_PAYLOAD_BYTES*8)
#define LEN_START_MSG_PAYLOAD_BITS	(LEN_MSG_PAYLOAD_BYTES*8)

// minimum time to interpolation Tx Message in the can bus
#define MIN_MSG_TX_TIME_ms			((LEN_MSG_NO_PAYLOAD_BITS+LEN_MSG_PAYLOAD_BITS) * (1.0/CAN_BAUDRATE))
extern const U16 MIN_MSG_TX_TIME_us;

// time since sync, when a message can start transmission
// is equal to time to tx message that starts interpolation + some time for computations (COMP_TIME_SINCE_SYNC_ms)
#if CAN_BAUDRATE == 50 || CAN_BAUDRATE == 100
#define COMP_TIME_SINCE_SYNC_ms	0.3
#define MSG_TX_TIME_ms			((LEN_MSG_NO_PAYLOAD_BITS+LEN_START_MSG_PAYLOAD_BITS) * (1.0/CAN_BAUDRATE)+COMP_TIME_SINCE_SYNC_ms)
extern const U16 MSG_TX_TIME_clkTks;
#elif
	#error "CAN_BAUDRATE not supported!"
#endif

// Packet
typedef struct packet_s
{
	U32 prio;
	U32 value;
	U16 x;
	U16 y;
} packet_t;
#define SIZE_OF_PRIO 4

void my_can_init(); 

U8 my_can_cmd_prepare_tx(st_cmd_t* cmd); // accepts a st_cmd_t* to be compatible with can lib
		
U8 my_can_cmd_rx(st_cmd_t* cmd); // accepts a st_cmd_t* to be compatible with can lib

S8 my_can_send(U8 type, packet_t *pkt);

#endif
