#include "hal.h"

//-------------------------------------------------------------------------------------------------------
//	void halWait_us(uint32_t timeout)
//
//	DESCRIPTION:
//		Runs an idle loop for [timeout] microseconds.
//
//  ARGUMENTS:
//      uint32_t timeout
//          The timeout in microseconds
//-------------------------------------------------------------------------------------------------------
void halWait_us(unsigned int timeout) {
    // This sequence uses exactly 8 clock cycle for each round
    do {
        NOP();
        NOP();
        NOP();
        NOP();
    } while (--timeout);
}
