//******************************************************************************
//! @file $RCSfile: config.h,v $
//!
//! Copyright (c) 2006 Atmel.
//!
//! Use of this program is subject to Atmel's End User License Agreement.
//! Please read file license.txt for copyright notice.
//!
//! @brief Configuration file for the following project:
//!             - can_spy_example_gcc
//!
//! This file can be parsed by Doxygen for automatic documentation generation.
//! This file has been validated with AVRStudio-412462/WinAVR-20060125.
//!
//! @version $Revision: 3.10 $ $Name: jtellier $
//!
//! @todo
//! @bug
//******************************************************************************

#ifndef _CONFIG_H_
#define _CONFIG_H_

//_____ I N C L U D E S ________________________________________________________
#include "compiler.h"
#include <avr/io.h>
#include <avr/interrupt.h>
#include "dvk90can1_board.h"

//_____ M A C R O S ____________________________________________________________

//_____ D E F I N I T I O N S _______________________________________________

    // -------------- MCU LIB CONFIGURATION
#define FOSC           8000        // 8 MHz External cristal
//#define F_CPU          (FOSC*1000) // Need for AVR GCC - Defined in Makefile (-DF_CPU=8000UL)

// -------------- UART LIB CONFIGURATION:
#define USE_TIMER16   TIMER16_1			// Must use TIMER16_3, because TIMER16_1 is used by simple_rtc!
#define USE_UART      UART_0
#define UART_BAUDRATE 115200
//#define UART_BAUDRATE 57600

// -------------- CAN LIB CONFIGURATION
#define CAN_BAUDRATE   50        // in kBit

// -------------- MISCELLANEOUS
// Using TIMER_2 as RTC
#define USE_TIMER8       TIMER8_2
//#define RTC_TIMER       2     // See "board.h"
//#define RTC_CLOCK       0     // See "board.h"

//_____ D E C L A R A T I O N S ________________________________________________

//______________________________________________________________________________

#endif  // _CONFIG_H


